/**
* \file: aoapSocket.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Baidu CarLife
*
* \author: P. Govindaraju / RBEB/GM / Pradeepa.Govindaraju@in.bosch.com
*
* \copyright (c) 2016 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef PLATFORM_BAIDU_BAIDU_CORE_INCLUDE_AOAPSOCKET_H_
#define PLATFORM_BAIDU_BAIDU_CORE_INCLUDE_AOAPSOCKET_H_

#include <map>
#include "IProtocolSocketConnector.h"
#include "ringBuffer.h"

#define MAX_CHANNEL 5 //5 ring buffers are enough.

//These values used to allocate memory for ring buffer and these value are finalized based on the static buffer allocated by core.

#define CMD_BUF_SIZE 120*1024//MSG_CMD_MEDIA_INFO<32k. 3 times the maximum packet size
#define VIDEO_BUF_SIZE 900*1024//normally VIDEO_DATA_SIZE<300X1024 3 times the maximum packet size
#define MEDIA_BUF_SIZE 300*1024
#define TTS_BUF_SIZE 50*1024//normally TTS_DATA_SIZE<10x1024
#define VR_BUF_SIZE 50*1024//normally VR_DATA_SIZE<10x1024


class aoapSocket: public IProtocolSocketConnector
{
public:
    // Client initialization
    aoapSocket();
    ~aoapSocket();

    bool connect (int ingAccId, int inDevId) ;

    // Data Transimission
    bool send(u8* data, u32 len, int inChannelId);
    bool getData(u32 inLen, u8 inChannelId, u8* outData);

    void wakeupThreads();

    static void* _WorkerThread(void* arg)
    {
        static_cast<aoapSocket*>(arg)->recievePackets();
        return NULL;
    };


private:
    int gAccId;
    int gDevId;

    int mChannelId;
    bool gotHeader;
    unsigned int msgSize;
    char buffer[1024];
    void *receiverThreadResult;
    std::condition_variable channelVacant;

    unsigned char sendMsg[2048];
    bool receiverThreadTerminationFlag;
    unsigned char readBuffer[300 * 1024]; //buffer size determined based on one maximum video packet. rest of the packets are less than 300 kB.
    unsigned char headerBuffer[8];
    char ringBufferNames[5][16] = {"CMD Channel", "Video Channel", "Media Channel", "TTS Channel", "VR Channel"};
    pthread_mutex_t readPacketsLock;
    std::mutex sendPacketsLock;

    ringBuffer socketRingBuffer[MAX_CHANNEL];
    pthread_t receiverThreadId;
    int previousWriteERROR;

    //    thread recieve;

    bool sendAoapData(const unsigned char * data, uint32_t size, int channelId);
    void recievePackets();

    bool pushData(u8, int);
    bool createSocketRingBuffers();
    int convertLength();
};

#endif /* PLATFORM_BAIDU_BAIDU_CORE_INCLUDE_AOAPSOCKET_H_ */
